/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.tagging;

import java.util.Hashtable;
import java.util.Vector;
import java.util.Iterator;
import java.util.LinkedHashMap;


public class LemmaVector {

    Vector<LemmaInfos> lemmas = new Vector();

    public LemmaVector() {
    }

    public Vector<LemmaInfos> getLemmas() {
        return lemmas;
    }

    public void addLemma(String ligne) {
        lemmas.add(new LemmaInfos(ligne));
    }

    /*public void filtre() {
//        ArrayList terms = new ArrayList();
//        Hashtable<String,String> lemmaPos = new Hashtable<String,String>();
        for (Iterator iter = lemmas.iterator(); iter.hasNext();) {

            LemmaInfos infos = (LemmaInfos) iter.next();
            if (infos.get_lex().equals("ADV") ||
                    infos.get_lex().equals("DET:ART") ||
                    infos.get_lex().equals("DET:POS") ||
                    infos.get_lex().equals("INT") ||
                    infos.get_lex().equals("KON") ||
                    infos.get_lex().equals("PRO") ||
                    infos.get_lex().equals("PRO:DEM") ||
                    infos.get_lex().equals("PRO:IND") ||
                    infos.get_lex().equals("PRO:PER") ||
                    infos.get_lex().equals("PRO:POS") ||
                    infos.get_lex().equals("PRO:REL") ||
                    infos.get_lex().equals("PRP") ||
                    infos.get_lex().equals("PRP:det") ||
                    infos.get_lex().equals("PUN") ||
                    infos.get_lex().equals("PUN:cit") ||
                    infos.get_lex().equals("SENT") ||
                    infos.get_lex().equals("SYM")) {
                iter.remove();
            }
        }
    }*/

    public String toLemmas() {
        String result = "";
        for (int i = 0; i < lemmas.size(); i++) {
            result += lemmas.elementAt(i).get_lemma() + " ";
        }
        return result;
    }

    public LinkedHashMap<LemmaInfos, Integer> toLemmasCount() {
        LinkedHashMap<LemmaInfos, Integer> lemmas_count = new LinkedHashMap<LemmaInfos, Integer>();

        try {
            Iterator<LemmaInfos> iter = lemmas.iterator();
            while (iter.hasNext()) {
                LemmaInfos lemma = iter.next();
                if (lemmas_count.containsKey(lemma)) {
                    Integer val = lemmas_count.get(lemma); // lemmas_count.get(lemma.get_lemma())+1 );   // incremente
                    lemmas_count.remove(lemma);
                    lemmas_count.put(lemma, val+1);
                } else {
                    lemmas_count.put(lemma, 1);
                }
            }
        } catch (Exception e) {
            System.out.println(String.format("toLemmasCount problem :" + e.toString()));
        }
        return lemmas_count;
    }

    public Hashtable<String, String> toLemmasPos() {
        Hashtable<String, String> lemmas_pos = new Hashtable<String, String>();

        try {
            Iterator iter = lemmas.iterator();
            while (iter.hasNext()) {
                LemmaInfos lemma = (LemmaInfos) iter.next();
                lemmas_pos.put(lemma.get_lemma(), lemma.get_lex());
            }
        } catch (Exception e) {
            System.out.println(String.format("toLemmasCount problem :" + e.toString()));
        }

        return lemmas_pos;
    }

    @Override
    public String toString() {
        String result = "";
        for (int i = 0; i < lemmas.size(); i++) {
            result += lemmas.elementAt(i).toString();
        }
        return result;
    }
    
}
